@ECHO off

title Default browser changer for Windows 7...11 ^| ver. 2.1 ^| 13.07.2022
cd "%~dp0"

SET "BrowserFileName=Chrome"
if exist "Opera.exe" @set "BrowserFileName=Opera"
if exist "vivaldi.exe" @set "BrowserFileName=vivaldi"

SET "BrowserDescr=%BrowserFileName% with custom tweaks"
SET "BrowserFullPath=%~dp0%BrowserFileName%.exe"
SET "BrowserIcon=\"%BrowserFullPath%\",0"
SET "BrowserConfig1=--disable-gpu-shader-disk-cache --disk-cache-dir=nul --disk-cache-size=1"
:: SET "BrowserConfig2=--disable-background-networking --no-default-browser-check"
SET "BrowserArgs=\"%BrowserFullPath%\" %BrowserConfig1% %BrowserConfig2% -- \"%%1\""

if not exist "%BrowserFullPath%" (ECHO ERROR: "%BrowserFullPath%" not found. &pause &exit)
ECHO "%BrowserFullPath%" found.

reg add HKEY_LOCAL_MACHINE /f>nul 2>&1
if ERRORLEVEL 1 (ECHO ERROR: you have no privileges. &pause &goto NOADMIN)

set DeletePaths=N
set /p DeletePaths=Delete registry paths? [Y/N] 
if /i "%DeletePaths%"=="Y" (
ECHO Delete registry paths
 reg delete "HKEY_LOCAL_MACHINE\Software\Classes\%BrowserFileName%HTML" /f
 reg delete "HKEY_LOCAL_MACHINE\Software\RegisteredApplications" /v "%BrowserFileName%" /f
 reg delete "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%" /f
)

set RegApsCaps=N
set /p RegApsCaps=Write RegisteredApplications, Capabilities? [Y/N] 
if /i "%RegApsCaps%"=="Y" (
ECHO RegisteredApplications Capabilities
 reg add "HKEY_LOCAL_MACHINE\Software\Classes\%BrowserFileName%HTML" /v "" /t REG_SZ /d "%BrowserFileName% Document" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Classes\%BrowserFileName%HTML\DefaultIcon" /v "" /t REG_SZ /d "%BrowserIcon%" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Classes\%BrowserFileName%HTML\shell\open\command" /v "" /t REG_SZ /d "%BrowserArgs%" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Classes\%BrowserFileName%URL" /v "" /t REG_SZ /d "%BrowserFileName% Protocol" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Classes\%BrowserFileName%URL" /v "EditFlags" /t REG_DWORD /d "2" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Classes\%BrowserFileName%URL" /v "FriendlyTypeName" /t REG_SZ /d "%BrowserFileName% Protocol" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Classes\%BrowserFileName%URL" /v "URL Protocol" /t REG_SZ /d "" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Classes\%BrowserFileName%URL\DefaultIcon" /v "" /t REG_SZ /d "%BrowserIcon%" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Classes\%BrowserFileName%URL\shell\open\command" /v "" /t REG_SZ /d "%BrowserArgs%" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%" /v "" /t REG_SZ /d "%BrowserFileName%" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%\Capabilities" /v "ApplicationDescription" /t REG_SZ /d "%BrowserDescr%" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%\Capabilities" /v "ApplicationIcon" /t REG_SZ /d "%BrowserIcon%" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%\Capabilities" /v "ApplicationName" /t REG_SZ /d "%BrowserFileName%" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%\Capabilities\FileAssociations" /v ".htm" /t REG_SZ /d "%BrowserFileName%HTML" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%\Capabilities\FileAssociations" /v ".html" /t REG_SZ /d "%BrowserFileName%HTML" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%\Capabilities\StartMenu" /v "StartMenuInternet" /t REG_SZ /d "%BrowserFileName%" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%\Capabilities\URLAssociations" /v "http" /t REG_SZ /d "%BrowserFileName%URL" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%\Capabilities\URLAssociations" /v "https" /t REG_SZ /d "%BrowserFileName%URL" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%\DefaultIcon" /v "" /t REG_SZ /d "%BrowserIcon%" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%\InstallInfo" /v "IconsVisible" /t REG_DWORD /d "1" /f
 reg add "HKEY_LOCAL_MACHINE\Software\Clients\StartMenuInternet\%BrowserFileName%\shell\open\command" /v "" /t REG_SZ /d "\"%BrowserFullPath%\"" /f
 reg add "HKEY_LOCAL_MACHINE\Software\RegisteredApplications" /v "%BrowserFileName%" /t REG_SZ /d "Software\Clients\StartMenuInternet\%BrowserFileName%\Capabilities" /f
)

set PoliciesChrome=N
set /p PoliciesChrome=Set policies for Chrome? [Y/N] 
if /i "%PoliciesChrome%"=="Y" (
 reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome" /v "MetricsReportingEnabled" /t REG_DWORD /d "0" /f
 reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome" /v "ShowHomeButton" /t REG_DWORD /d "1" /f
 reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome" /v "RestoreOnStartup" /t REG_DWORD /d "1" /f
 reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Google\Chrome" /v "DefaultBrowserSettingEnabled" /t REG_DWORD /d "0" /f
)

:: "%windir%\system32\control.exe" /name Microsoft.DefaultPrograms /page pageDefaultProgram\pageAdvancedSettings?pszAppName=%BrowserFileName%
goto FIN

:NOADMIN
:: reg add "HKEY_CURRENT_USER\Software\Microsoft\Windows\Shell\Associations\UrlAssociations\http\UserChoice" /v "Progid" /t REG_SZ /d "%BrowserFileName%URL" /f
:: reg add "HKEY_CURRENT_USER\Software\Microsoft\Windows\Shell\Associations\UrlAssociations\https\UserChoice" /v "Progid" /t REG_SZ /d "%BrowserFileName%URL" /f

:FIN
"%windir%\system32\control.exe" /name Microsoft.DefaultPrograms /page pageDefaultProgram
@pause
